﻿using System;
using System.Text;
using System.Xml;

namespace AHOBPR_Job_Runner.DasXml
{
    [Serializable]
    public class DocumentIdentification
    {
        public String Id { get; set; }
        public String CategoryText { get; set; }
        public String CategoryDescriptionText { get; set; }
        public String IdentificationSourceText { get; set; }
         
        public DocumentIdentification()        {        }

        public void GetXml(XmlWriter writer)
        {
            String nameSpace = "nc";
            writer.WriteStartElement("DocumentIdentification", nameSpace);
            writer.WriteWhitespace("\r\n\t\t\t\t");

            //ID:
            {
                writer.WriteElementString("IdentificationID", nameSpace, Id);
                writer.WriteWhitespace("\r\n\t\t\t\t");
            }

            //Category Text:
            {
                writer.WriteElementString("IdentificationCategoryText", nameSpace, CategoryText);
            }

            if (IdentificationSourceText == "AHOBPR")
            {
                writer.WriteWhitespace("\r\n\t\t\t\t");
                //Category Description Text:
                {
                    writer.WriteElementString("IdentificationCategoryDescriptionText", nameSpace, CategoryDescriptionText);
                    writer.WriteWhitespace("\r\n\t\t\t\t");
                }

                //Identification Source Text:
                {
                    writer.WriteElementString("IdentificationSourceText", nameSpace, IdentificationSourceText);
                    writer.WriteWhitespace("\r\n\t\t\t");
                }
            }
            else
            {
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            writer.WriteEndElement();
            writer.WriteWhitespace("\r\n\t\t\t");
        }
    }
}
